﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.ProxyAdd
{
    /// <summary>
    /// Get Service Appointment step.
    /// </summary>
    public class GetServiceAppointmentStep : FilterBase<ProxyAddStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(ProxyAddStateObject state)
        {
            using (var context = new Xrm(state.OrganizationServiceProxy))
            {
                if (state.AppointmentId != null)
                {
                    state.Appointment = context.AppointmentSet.FirstOrDefault(x => x.Id == state.AppointmentId);
                    if (state.Appointment == null) throw new Exception("Appointment cannot be null");

                    if (state.Appointment != null && state.Appointment.cvt_serviceactivityid != null) state.ServiceAppointment = context.ServiceAppointmentSet.FirstOrDefault(x => x.Id == state.Appointment.cvt_serviceactivityid.Id);
                    if (state.ServiceAppointment == null) throw new Exception(string.Format("Unable to retrieve Service Appointment for group with AppointmentId - {0}", state.AppointmentId));
                    if (state.Appointment.cvt_Site == null) throw new Exception(string.Format("No Patient Site Listed on Group Appointment with Id {0}", state.AppointmentId));

                    var patSite = context.mcs_siteSet.FirstOrDefault(x => x.Id == state.Appointment.cvt_Site.Id);

                    if (patSite != null) state.PatientSite = patSite.mcs_ParentStationNumber;
                    else throw new Exception(string.Format("Unable to find Site with Id {0}", state.Appointment.cvt_Site.Id));
                }
                else
                {
                    state.ServiceAppointment = context.ServiceAppointmentSet.FirstOrDefault(x => x.Id == state.ServiceAppointId);
                    if (state.ServiceAppointment == null) throw new Exception(string.Format("Unable to retrieve Service Appointment - {0}", state.ServiceAppointId));

                    // Get Patient Site
                    if (state.ServiceAppointment.mcs_relatedsite == null)
                    {
                        state.PatientSite = string.Empty;
                        Logger.Instance.Debug("Patient Site is empty.");
                    }
                    else
                    {
                        var relatedSiteId = context.mcs_siteSet.FirstOrDefault(x => x.mcs_siteId == state.ServiceAppointment.mcs_relatedsite.Id);
                        state.PatientSite = relatedSiteId != null ? relatedSiteId.mcs_ParentStationNumber : string.Empty;
                        if (string.IsNullOrEmpty(state.PatientSite)) Logger.Instance.Debug("No Patient Site Found.");
                    }
                }

                // Get Service (TSA)
                state.Service = state.ServiceAppointment.mcs_relatedtsa == null ? null : context.mcs_servicesSet.FirstOrDefault(x => x.mcs_servicesId == state.ServiceAppointment.mcs_relatedtsa.Id);
                if (state.Service == null) throw new Exception("Unable to retrieve the Service (TSA)");

                // Get Provider Site
                if (state.ServiceAppointment.mcs_relatedprovidersite == null)
                {
                    state.ProviderSite = string.Empty;
                    Logger.Instance.Debug("Provider Site is empty.");
                }
                else
                {
                    var relatedProviderSiteId = context.mcs_siteSet.FirstOrDefault(x => x.mcs_siteId == state.ServiceAppointment.mcs_relatedprovidersite.Id);
                    state.ProviderSite = relatedProviderSiteId != null ? relatedProviderSiteId.mcs_ParentStationNumber : string.Empty;
                    if (string.IsNullOrEmpty(state.ProviderSite)) Logger.Instance.Debug("No Provider Site Found.");
                }
            }
        }
    }
}